/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.kawakubo;

import java.util.ArrayList;

/**
 *
 * @author tomoharu
 */
public class BasketHelper {
    
    BasketDAO basketDAO = new BasketDAOImpl();

    public int getBasketId(String userId) {
        int basketId = basketDAO.getBasketId(userId);
        if (basketId == 0) {
            basketDAO.insertBasket(userId);
            basketId = basketDAO.getBasketId(userId);
        }
        return basketId;
    }

    public void removeBasket(int basketId) {
        basketDAO.removeBasket(basketId);
    }

    public void insertBasketItems(int basketId, String[] meigaraItems) {
        ArrayList<String> insertedIds = basketDAO.retrieveItems(basketId, meigaraItems);
        basketDAO.insertItems(basketId, insertedIds);
    }

    public void updateBasketItems(String[] basketIds, String[] allQuantity) {
        basketDAO.updateItems(basketIds, allQuantity);
    }
    
    public ArrayList<BasketItem> getBasketItems(int basketId) {
        return basketDAO.getBasketItems(basketId);
    }

    // 第6回で追加
    public ArrayList getTotalCharge(ArrayList<BasketItem> basketItems) {
        ArrayList totalCharge = new ArrayList();
        int sumItems = 0;
        int shippingCost = 1500;
        int total = 0;
        // 明細金額の合計を求める
        for (int i = 0; i < basketItems.size(); i++) {
            sumItems += basketItems.get(i).getItemTotal();
        }
        total = sumItems + shippingCost;
        totalCharge.add(sumItems);
        totalCharge.add(shippingCost);
        totalCharge.add(total);
        return totalCharge;
    }
}
